class RtNode;
class RtMaster;

extern "C" {
	long	db_ntohl(long);
	void	db_ntohla(long*, int);
	short	db_ntohs(short);
	void	db_ntohsa(short*, int);
	int	dbopen(char*, int=0);
	int	dbpopen(char**);
	void	dbclose(int);
	int	dbrequest(int, int, int, int, int =0, int =0, int =0);
	int dbload(int, int, char*, char**);
	extern int dberrno;
	extern int dbpipeid;
}

class RtConnections : public PadRcv {
	friend	RtNode;
	RtNode	*child;
	Pad	*pad;
	Master	*hostmaster;
	void	exit();
	char	*kbd(char*);
	char	*help(long);
	void	insert(RtNode*);
	void	openhelp();
	RtNode	*search(char*);
public:
		RtConnections();
};

class RtNode : public PadRcv {
	friend	RtConnections;
	RtConnections *parent;
	RtNode	*sibling;
	char	*inetname;
	int	fd;
	int	nboards;
	RtMaster **bmaster;
	Pad	*pad;
	char	*help(long);
	void	open();
public:
		RtNode(RtConnections*,char*);
	char	*name();
	Index	carte();
};

class RtMaster : public Master {
	friend	RtNode;
	friend	NrtxMaster;
protected:
	int	fd;
	int	boardid;
	int	pipeid;
	char	*bname;
	RtNode	*parent;
virtual	void	open();
public:
	RtMaster(int,int,int,RtNode*);
	char	*name();
virtual	Index	carte();
};
